function avexp = get_exp(X, delta0, delta1, mu, phi,hmin,hmax)
% Calculate expectations component (average expected short-term interest
% rate) of long-term interest rate
% Bauer, Rudebusch, Wu (2014, AER) Comment on ``Term Premia and
% Inflation Uncertainty: Empirical Evidence from an International Panel Dataset''
%
% Arguments:
%  X - TxN matrix with risk factors
%  delta0, delta1 - parameters of short-rate equation
%  mu, phi - VAR parameters
%
% Returns:
%  avexp - expectations component of forward rate from hmin to hmax
%


[T,N] = size(X);
avexp = zeros(T, 1);
for t=1:T;
    g = zeros(N, hmax);
    g(:,1)=X(t,:);
    for j=2:hmax;
        g(:,j)=mu+(phi*g(:,j-1));
    end;
    g=g(1:3,hmin:hmax);
    avexp(t)=mean(max(delta0+(delta1'*g),0));
end;
end
